﻿' “拆分页”项模板在 http://go.microsoft.com/fwlink/?LinkId=234234 上有介绍

''' <summary>
''' 显示组标题、组内各项的列表以及当前选定项的
''' 详细信息的页。
''' </summary>
Public NotInheritable Class $safeitemname$
    Inherits Page

    ''' <summary>
    ''' NavigationHelper 在每页上用于协助导航和
    ''' 进程生命期管理
    ''' </summary>
    Public ReadOnly Property NavigationHelper As Common.NavigationHelper
        Get
            Return Me._navigationHelper
        End Get
    End Property
    Private _navigationHelper As Common.NavigationHelper

    ''' <summary>
    ''' 可将其更改为强类型视图模型。
    ''' </summary>
    Public ReadOnly Property DefaultViewModel As Common.ObservableDictionary
        Get
            Return Me._defaultViewModel
        End Get
    End Property
    Private _defaultViewModel As New Common.ObservableDictionary()

    Public Sub New()
        InitializeComponent()
        Me._navigationHelper = New Common.NavigationHelper(Me)
        AddHandler Me._navigationHelper.LoadState, AddressOf NavigationHelper_LoadState
        AddHandler Me._navigationHelper.SaveState, AddressOf NavigationHelper_SaveState
        AddHandler Me.itemListView.SelectionChanged, AddressOf ItemListView_SelectionChanged
        Me.NavigationHelper.GoBackCommand = New Common.RelayCommand(AddressOf Me.GoBack, AddressOf Me.CanGoBack)

        AddHandler Window.Current.SizeChanged, AddressOf Winow_SizeChanged
        Me.InvalidateVisualState()
    End Sub

    ''' <summary>
    ''' 在选定列表中的项时进行调用。
    ''' </summary>
    ''' <param name="sender">显示所选项的 GridView。</param>
    ''' <param name="e">描述如何更改选择内容的事件数据。</param>
    Private Sub ItemListView_SelectionChanged(sender As Object, e As SelectionChangedEventArgs)
        If Me.UsingLogicalPageNavigation() Then
            Me.InvalidateVisualState()
        End If
    End Sub

    ''' <summary>
    ''' 使用在导航过程中传递的内容填充页。  在从以前的会话
    ''' 重新创建页时，也会提供任何已保存状态。
    ''' </summary>
    ''' <param name="sender">
    ''' 事件的来源; 通常为 <see cref="NavigationHelper"/>
    ''' </param>
    ''' <param name="e">事件数据，其中既提供在最初请求此页时传递给
    ''' <see cref="Frame.Navigate"/> 的导航参数，又提供
    ''' 此页在以前会话期间保留的状态的
    ''' 字典。 首次访问页面时，该状态将为 null。</param>
    Private Sub NavigationHelper_LoadState(sender As Object, e As Common.LoadStateEventArgs)
        ' TODO:  将可绑定组分配给 Me.DefaultViewModel("Group")
        ' TODO:  将可绑定项集合分配给 Me.DefaultViewModel("Items")
        If e.PageState Is Nothing Then
            ' 当这是新页时，除非正在使用逻辑页导航，
            ' 否则会自动选择第一项(请参见下面的逻辑页导航 #region。)
            If Not Me.UsingLogicalPageNavigation() AndAlso Me.itemsViewSource.View IsNot Nothing Then
                Me.itemsViewSource.View.MoveCurrentToFirst()
            End If
        Else

            ' 还原与此页关联的以前保存的状态
            If e.PageState.ContainsKey("SelectedItem") AndAlso Me.itemsViewSource.View IsNot Nothing Then
                ' TODO:  使用通过 pageState("SelectedItem")值指定的所选项
                '       调用 Me.itemsViewSource.View.MoveCurrentTo()
            End If
        End If
    End Sub

    ''' <summary>
    ''' 保留与此页关联的状态，以防挂起应用程序或
    ''' 从导航缓存中放弃此页。  值必须符合
    ''' <see cref="Common.SuspensionManager.SessionState"/> 的序列化要求。
    ''' </summary>
    ''' <param name="sender">
    ''' 事件的来源; 通常为 <see cref="NavigationHelper"/>
    ''' </param>
    ''' <param name="e">提供要使用可序列化状态填充的空字典
    '''的事件数据。</param>
    Private Sub NavigationHelper_SaveState(sender As Object, e As Common.SaveStateEventArgs)
        If Me.itemsViewSource.View IsNot Nothing Then
            Dim selectedItem As Object = Me.itemsViewSource.View.CurrentItem
            ' TODO:  派生一个可序列化导航参数并将该参数分配给
            '       pageState("SelectedItem")
        End If
    End Sub

#Region "逻辑页导航"

    ' 设计了拆分页，以便 Window 具有足够的空间同时显示
    ' 列表和详细信息，一次将仅显示一个窗格。
    '
    ' 这完全通过一个可表示两个逻辑页的单一物理页
    ' 实现。  使用下面的代码可以实现此目标，且用户不会察觉到
    ' 区别。

    Private Const MinimumWidthForSupportingTwoPanes As Integer = 768

    ''' <summary>
    ''' 在确定该页是应用作一个逻辑页还是两个逻辑页时进行调用。
    ''' </summary>
    ''' <returns>当相关视图状态为纵向或对齐时为 true，否则
    '''为 false。</returns>
    Private Function UsingLogicalPageNavigation() As Boolean
        Return Window.Current.Bounds.Width < MinimumWidthForSupportingTwoPanes
    End Function

    ''' <summary>
    ''' 在 Window 改变大小时调用
    ''' </summary>
    ''' <param name="sender">当前的 Window</param>
    ''' <param name="e">描述 Window 新大小的事件数据</param>
    Private Sub Winow_SizeChanged(sender As Object, e As Windows.UI.Core.WindowSizeChangedEventArgs)
        Me.InvalidateVisualState()
    End Sub

    Private Sub InvalidateVisualState()
        Dim visualState As String = DetermineVisualState()
        VisualStateManager.GoToState(Me, visualState, False)
        Me.NavigationHelper.GoBackCommand.RaiseCanExecuteChanged()
    End Sub

    Private Function CanGoBack() As Boolean
        If Me.UsingLogicalPageNavigation() AndAlso Me.itemListView.SelectedItem IsNot Nothing Then
            Return True
        Else
            Return Me.NavigationHelper.CanGoBack()
        End If
    End Function
    Private Sub GoBack()
        If Me.UsingLogicalPageNavigation() AndAlso Me.itemListView.SelectedItem IsNot Nothing Then
            ' 如果逻辑页导航起作用且存在选定项，则当前将显示
            ' 选定项的详细信息。    清除选择后将返回到
            ' 项列表。    从用户的角度来看，这是一个逻辑后向
            ' 导航。
            Me.itemListView.SelectedItem = Nothing
        Else
            Me.NavigationHelper.GoBack()
        End If
    End Sub

    ''' <summary>
    ''' 在确定对应于应用程序视图状态的可视状态的名称时进行
    ''' 的名称。
    ''' </summary>
    ''' <returns>所需的可视状态的名称。  此名称与视图状态的名称相同，
    ''' 但在纵向和对齐视图中存在选定项时例外，在纵向和对齐视图中，
    ''' 此附加逻辑页通过添加 _Detail 后缀表示。</returns>
    ''' <remarks></remarks>
    Private Function DetermineVisualState() As String

        ' 在视图状态更改时更新后退按钮的启用状态
        Dim logicalPageBack As Boolean = Me.UsingLogicalPageNavigation() AndAlso Me.itemListView.SelectedItem IsNot Nothing

        If logicalPageBack Then Return "SinglePane_Detail"
        Return "SinglePane"
    End Function

#End Region

#Region "NavigationHelper 注册"

    ''' 此部分中提供的方法只是用于使
    ''' NavigationHelper 可响应页面的导航方法。
    ''' 
    ''' 应将页面特有的逻辑放入用于
    ''' <see cref="Common.NavigationHelper.LoadState"/>
    ''' 和 <see cref="Common.NavigationHelper.SaveState"/> 的事件处理程序中。
    ''' 除了在会话期间保留的页面状态之外
    ''' LoadState 方法中还提供导航参数。

    Protected Overrides Sub OnNavigatedTo(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedTo(e)
    End Sub

    Protected Overrides Sub OnNavigatedFrom(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedFrom(e)
    End Sub

#End Region
End Class
